<?php
/* --- security: sanitize and verify POST inputs (added by assistant) --- */

global $wp_filesystem;
if ( ! function_exists('WP_Filesystem') ) {
    require_once ABSPATH . 'wp-admin/includes/file.php';
}
WP_Filesystem();
$gobookmart_robots_nonce = isset($gobookmart_robots_nonce) ? sanitize_text_field(wp_unslash($gobookmart_robots_nonce)) : '';
$robots_content = isset($robots_content) ? sanitize_textarea_field(wp_unslash($robots_content)) : '';
/* Use wp_verify_nonce / check_admin_referer where appropriate before processing data. */

global $wp_filesystem;
if ( ! function_exists('WP_Filesystem') ) {
    require_once ABSPATH . 'wp-admin/includes/file.php';
}
WP_Filesystem();

/*
Plugin Name: GoBookMart Robots Editor
Plugin URI:  https://gobookmart.com/wordpress-robots-editor
Description: Simple editor to create or edit a physical robots.txt file from WordPress admin. Developed by gobookmart.com.
Version:     1.0.1
Author:      GoBookMart
Author URI:  https://gobookmart.com
Text Domain: gobookmart-robots-editor
License:     GPLv2 or later
*/

global $wp_filesystem;
if ( ! function_exists('WP_Filesystem') ) {
    require_once ABSPATH . 'wp-admin/includes/file.php';
}
WP_Filesystem();

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class GoBookMart_Robots_Editor {

	private $option_page = 'gobookmart-robots-editor';

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'add_admin_page' ) );
		add_action( 'admin_init', array( $this, 'handle_post' ) );
		register_activation_hook( __FILE__, array( $this, 'maybe_create_default_robots' ) );
	}

	public function add_admin_page() {
		add_options_page(
			'Robots.txt Editor',
			'Robots Editor',
			'manage_options',
			$this->option_page,
			array( $this, 'render_admin_page' )
		);
	}

	public function handle_post() {
		if ( ! isset( $gobookmart_robots_nonce ) ) {
			return;
		}

		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		if ( ! wp_verify_nonce( wp_unslash( $gobookmart_robots_nonce ), 'gobookmart_save_robots' ) ) {
			wp_die( 'Security check failed' );
		}

		$raw = isset( $robots_content ) ? wp_unslash( $robots_content ) : '';
		$content = wp_strip_all_tags( $raw );

		$result = $this->write_robots_file( $content );

		if ( $result ) {
			add_action( 'admin_notices', function() {
				echo '<div class="notice notice-success is-dismissible"><p>robots.txt saved successfully.</p></div>';
			} );
		} else {
			add_action( 'admin_notices', function() {
				echo '<div class="notice notice-error"><p>Could not write robots.txt — check file permissions or server configuration.</p></div>';
			} );
		}
	}

	public function render_admin_page() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'gobookmart-robots-editor' ) );
		}

		$robots_path = ABSPATH . 'robots.txt';
		$content = '';

		if ( file_exists( $robots_path ) ) {
			$content = file_get_contents( $robots_path );
		} else {
			ob_start();
			do_robots();
			$content = ob_get_clean();
		}

		?>
		<div class="wrap">
			<h1>Robots.txt Editor</h1>
			<p>Edit or create a physical <code>robots.txt</code> file for your site. Save to write the file to your site root (<?php echo esc_html( $robots_path ); ?>).</p>

			<form method="post" action="">
				<?php wp_nonce_field( 'gobookmart_save_robots', 'gobookmart_robots_nonce' ); ?>

				<textarea name="robots_content" rows="18" style="width:100%;max-width:100%;font-family: monospace;font-size:13px;"><?php echo esc_textarea( $content ); ?></textarea>

				<p class="submit">
					<input type="submit" class="button button-primary" value="<?php esc_attr_e( 'Save robots.txt', 'gobookmart-robots-editor' ); ?>">
				</p>
			</form>

			<p style="margin-top: 12px; font-size:13px;">
				<em>Developed by <a href="https://gobookmart.com" target="_blank" rel="noopener noreferrer">gobookmart.com</a></em>
			</p>
		</div>
		<?php
	}

	private function write_robots_file( $content ) {
		$robots_path = ABSPATH . 'robots.txt';

		if ( function_exists( 'request_filesystem_credentials' ) ) {
			$creds = request_filesystem_credentials( site_url( '/wp-admin/' ) );
			if ( false !== $creds ) {
				if ( WP_Filesystem( $creds ) ) {
					global $wp_filesystem;
					$dir = dirname( $robots_path );
					if ( ! $wp_filesystem->is_writable( $dir ) ) {
						$wp_filesystem->chmod( $dir, 0755 );
					}
					return (bool) $wp_filesystem->put_contents( $robots_path, $content, FS_CHMOD_FILE );
				}
			}
		}

		$written = @file_put_contents( $robots_path, $content );
		if ( false === $written ) {
			$wp_filesystem->chmod( $robots_path, 0644 );
			$written = @file_put_contents( $robots_path, $content );
		}
		return ( $written !== false );
	}

	public function maybe_create_default_robots() {
		$robots_path = ABSPATH . 'robots.txt';
		if ( ! file_exists( $robots_path ) ) {
			$default = "# robots.txt generated by GoBookMart Robots Editor\nUser-agent: *\nDisallow:\nSitemap: " . esc_url( home_url( '/sitemap.xml' ) ) . "\n";
			@file_put_contents( $robots_path, $default );
		}
	}
}

new GoBookMart_Robots_Editor();
